<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest;

use Twilio\Domain;
use Twilio\Exceptions\TwilioException;
use Twilio\Rest\Numbers\V2;

/**
 * @property \Twilio\Rest\Numbers\V2 $v2
 * @property \Twilio\Rest\Numbers\V2\RegulatoryComplianceList $regulatoryCompliance
 */
class Numbers extends Domain {
    protected $_v2 = null;

    /**
     * Construct the Numbers Domain
     *
     * @param \Twilio\Rest\Client $client Twilio\Rest\Client to communicate with
     *                                    Twilio
     * @return \Twilio\Rest\Numbers Domain for Numbers
     */
    public function __construct(Client $client) {
        parent::__construct($client);

        $this->baseUrl = 'https://numbers.twilio.com';
    }

    /**
     * @return \Twilio\Rest\Numbers\V2 Version v2 of numbers
     */
    protected function getV2() {
        if (!$this->_v2) {
            $this->_v2 = new V2($this);
        }
        return $this->_v2;
    }

    /**
     * Magic getter to lazy load version
     *
     * @param string $name Version to return
     * @return \Twilio\Version The requested version
     * @throws TwilioException For unknown versions
     */
    public function __get($name) {
        $method = 'get' . \ucfirst($name);
        if (\method_exists($this, $method)) {
            return $this->$method();
        }

        throw new TwilioException('Unknown version ' . $name);
    }

    /**
     * Magic caller to get resource contexts
     *
     * @param string $name Resource to return
     * @param array $arguments Context parameters
     * @return \Twilio\InstanceContext The requested resource context
     * @throws TwilioException For unknown resource
     */
    public function __call($name, $arguments) {
        $method = 'context' . \ucfirst($name);
        if (\method_exists($this, $method)) {
            return \call_user_func_array(array($this, $method), $arguments);
        }

        throw new TwilioException('Unknown context ' . $name);
    }

    /**
     * @return \Twilio\Rest\Numbers\V2\RegulatoryComplianceList
     */
    protected function getRegulatoryCompliance() {
        return $this->v2->regulatoryCompliance;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString() {
        return '[Twilio.Numbers]';
    }
}