<?php

namespace App\Http\Requests\Admin\FrontSettings;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class SmNewsCategorRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'category_name' => ['required', 'max:200', Rule::unique('sm_news_categories', 'category_name')->where('school_id', auth()->user()->school_id)->ignore($this->id)],
        ];

    }
}
