<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Visitor Entry Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #ffffff;
            color: #333333;
        }
        .header {
            background-color: #2c3e50;
            color: #ffffff;
            padding: 15px;
            text-align: center;
            border-bottom: 2px solid #3498db;
            margin-bottom: 15px;
        }
        .header h1 {
            margin: 0;
            font-size: 22px;
            font-weight: bold;
            text-transform: uppercase;
        }
        .header p {
            margin: 5px 0 0;
            font-size: 11px;
        }
        .container {
            padding: 15px;
            width: 100%;
            margin: 0 auto;
            background-color: #ffffff;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        }
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 9px;
            border: 1px solid #dddddd;
        }
        th, td {
            border: 1px solid #dddddd;
            padding: 6px;
            text-align: left;
            word-wrap: break-word;
            overflow-wrap: break-word;
            vertical-align: top;
        }
        th {
            background-color: #ecf0f1;
            font-weight: bold;
            color: #2c3e50;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            white-space: nowrap;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        tr:hover {
            background-color: #eef2f7;
        }
        .footer {
            text-align: center;
            padding: 8px;
            font-size: 9px;
            color: #7f8c8d;
            border-top: 1px solid #dddddd;
            margin-top: 15px;
        }
        /* Adjusted column widths for entry logs */
        th:nth-child(1), td:nth-child(1) { width: 10%; } /* ID */
        th:nth-child(2), td:nth-child(2) { width: 15%; } /* Name */
        th:nth-child(3), td:nth-child(3) { width: 15%; } /* Society */
        th:nth-child(4), td:nth-child(4) { width: 15%; } /* Entry Time */
        th:nth-child(5), td:nth-child(5) { width: 15%; } /* Visit Mode */
        th:nth-child(6), td:nth-child(6) { width: 15%; } /* Status */
        th:nth-child(7), td:nth-child(7) { width: 15%; } /* User */
    </style>
</head>
<body>
    <div class="header">
        <h1>Visitor Entry Report</h1>
        <p><?php echo e($socName); ?> | Generated: <?php echo e(date('h:i A IST, F d, Y')); ?> (<?php echo e(date('h:i A IST')); ?>)</p>
    </div>
    <div class="container">
        <?php if($visitors->isEmpty()): ?>
            <p style="text-align: center; color: #7f8c8d; font-size: 12px;">No visitor entry logs found.</p>
        <?php else: ?>
            <table>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Society</th>
                        <th>Entry Time</th>
                        <th>Visit Mode</th>
                        <th>Status</th>
                        <th>User</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $visitors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $visitor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($visitor->VR_Id); ?></td>
                            <td><?php echo e($visitor->Vr_Name ?? 'N/A'); ?></td>
                            <td><?php echo e($visitor->society->SocName ?? 'N/A'); ?></td>
                            <td><?php echo e($visitor->Vr_Ent_DT ?? 'N/A'); ?></td>
                            <td><?php echo e($visitor->Visit_Mode ?? 'N/A'); ?></td>
                            <td><?php echo e($visitor->Vr_Status ?? 'N/A'); ?></td>
                            <td><?php echo e($visitor->user ? $visitor->user->name ?? 'N/A' : 'N/A'); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
    <div class="footer">
        Generated on: <?php echo e(date('h:i A IST, F d, Y')); ?> | Page 1 of 1
    </div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\SocietyNewWebsite\app (8)\resources\views/pdf/visitor_entry.blade.php ENDPATH**/ ?>