<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;
use App\Http\Controllers\RoleMasterController;
use App\Http\Controllers\RoleMappingController;
use App\Http\Controllers\ModuleMasterController;
use App\Http\Controllers\PackageModuleLinkController;
use App\Http\Controllers\SociTypeController;
use App\Http\Controllers\SocietyMasterController;
use App\Http\Controllers\SociDivisionController;
use App\Http\Controllers\SocBlockController;
use App\Http\Controllers\UnitTypeController;
use App\Http\Controllers\SocUnitController;
use App\Http\Controllers\ComDesiController;
use App\Http\Controllers\SociResoBookController;
use App\Http\Controllers\SocietyCommitteeController;
use App\Http\Controllers\UnitMemLinkController;
use App\Http\Controllers\RelationMasterController;
use App\Http\Controllers\FeeController;
use App\Http\Controllers\FeeConfigController;
use App\Http\Controllers\LockerTypeController;
use App\Http\Controllers\LockerUnitController;
use App\Http\Controllers\LockerAllotmentController;
use App\Http\Controllers\PBTypeController;
use App\Http\Controllers\PBUnitController;
use App\Http\Controllers\PBAllotmentController;
use App\Http\Controllers\PollCategoryController;
use App\Http\Controllers\PollBookController;
use App\Http\Controllers\PollActionController;
use App\Http\Controllers\PollActionLogController;
use App\Http\Controllers\NoticeCategoryController;
use App\Http\Controllers\NoticeActionController;
use App\Http\Controllers\NoticeBoardController;
use App\Http\Controllers\NoticeActionLogController;
use App\Http\Controllers\NoticeGallaryController;
use App\Http\Controllers\CompCategoryController;
use App\Http\Controllers\CompActionController;
use App\Http\Controllers\ComplaintBookController;
use App\Http\Controllers\CompActionLogController;
use App\Http\Controllers\MeetingBookController;
use App\Http\Controllers\MeetingInviteeController;
use App\Http\Controllers\AmenityMasterController;
use App\Http\Controllers\AmenityConfigController;
use App\Http\Controllers\AmenityGallaryController;
use App\Http\Controllers\AmenityBookingController;
use App\Http\Controllers\VendorRegisterController;
use App\Http\Controllers\GuardCategoryController;
use App\Http\Controllers\SecurityAgencyController;
use App\Http\Controllers\GuardRegistrationController;
use App\Http\Controllers\DutyPointController;
use App\Http\Controllers\GuardDutyRegisterController;
use App\Http\Controllers\GuardDutyAttanController;
use App\Http\Controllers\SociResAttnController;
use App\Http\Controllers\GateMasterController;
use App\Http\Controllers\VisitorTypeController;
use App\Http\Controllers\ServiceCategoryController;
use App\Http\Controllers\FreelancerRegisterController;
use App\Http\Controllers\FreeLServLinkController;
use App\Http\Controllers\FreeLPackMastController;
use App\Http\Controllers\FreeLServOfferController;
use App\Http\Controllers\FreeLRatingController;
use App\Http\Controllers\FreeLClasssifiedController;
use App\Http\Controllers\ClassiGallaryController;
use App\Http\Controllers\VisitorRegisterController;
use App\Http\Controllers\ParkingTypeController;
use App\Http\Controllers\ParkingLevelController;
use App\Http\Controllers\ParkingSlotController;
use App\Http\Controllers\CompGallaryController;
use App\Http\Controllers\ParkingMasterController;
use App\Http\Controllers\VehicleMasterController;
use App\Http\Controllers\CoMasterController;
use App\Http\Controllers\BranchMController;
use App\Http\Controllers\LedgGrpController;
use App\Http\Controllers\PrtyMastController;
use App\Http\Controllers\FinanTrnController;
use App\Http\Controllers\SubFinanTrnController;
use App\Http\Controllers\FeeTransactionController;
use App\Http\Controllers\FilterController;
use App\Http\Controllers\DiscountTypeController;
use App\Http\Controllers\DiscCrieteriaController;
use App\Http\Controllers\DiscUnitController;
use App\Http\Controllers\DiscCondMastController;
use App\Http\Controllers\PackageMasterController;
use App\Http\Controllers\DiscountMasterController;
use App\Http\Controllers\ScoPackageController;
use App\Http\Controllers\ScoDiscMapController;




/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// Group all routes under throttle:60,1 to limit 60 requests per minute
Route::middleware('throttle:60,1')->group(function () {

    // Sanctum authenticated route
    Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
        return $request->user();
    });

    // User routes
    Route::apiResource('users', UserController::class);
    Route::post('login', [UserController::class, 'login']);

    // Role and package management
    Route::apiResource('roles', RoleMasterController::class);
    Route::apiResource('role-mappings', RoleMappingController::class);

    Route::apiResource('modules', ModuleMasterController::class);
    Route::apiResource('package-module-links', PackageModuleLinkController::class);

    // Society management
    Route::apiResource('soci-types', SociTypeController::class);
    Route::apiResource('societies', SocietyMasterController::class);
    Route::post('/societies/login', [SocietyMasterController::class, 'login']);
    Route::apiResource('soci-divisions', SociDivisionController::class);
    Route::apiResource('soc-blocks', SocBlockController::class);
    Route::apiResource('unit-types', UnitTypeController::class);
    Route::apiResource('soc-units', SocUnitController::class);
    Route::apiResource('com-desis', ComDesiController::class);
    Route::apiResource('soci-reso-books', SociResoBookController::class);
    Route::apiResource('society-committees', SocietyCommitteeController::class);
    Route::apiResource('unit-mem-links', UnitMemLinkController::class);
    Route::apiResource('relation-masters', RelationMasterController::class);

    // Fee management
    Route::apiResource('fees-masters', FeeController::class);
    Route::apiResource('fees-configs', FeeConfigController::class);

    // Locker management
    Route::apiResource('locker-types', LockerTypeController::class);
    Route::apiResource('locker-units', LockerUnitController::class);
    Route::apiResource('locker-allotments', LockerAllotmentController::class);

    // PB (Parking/Other) management
    Route::apiResource('pb-types', PBTypeController::class);
    Route::apiResource('pb-units', PBUnitController::class);
    Route::apiResource('pb-allotments', PBAllotmentController::class);

    // Poll management
    Route::apiResource('poll_categories', PollCategoryController::class);
    Route::apiResource('poll_books', PollBookController::class);
    Route::apiResource('poll_actions', PollActionController::class);
    Route::apiResource('poll_action_logs', PollActionLogController::class);

    // Notice management
    Route::apiResource('notice_categories', NoticeCategoryController::class);
    Route::apiResource('notice_actions', NoticeActionController::class);
    Route::apiResource('notice_boards', NoticeBoardController::class);
    Route::apiResource('notice_action_logs', NoticeActionLogController::class);
    Route::apiResource('notice_gallaries', NoticeGallaryController::class);
    Route::delete('notice_gallaries/{id}/files', [NoticeGallaryController::class, 'deleteFiles'])->name('notice_gallaries.delete_files');

    // Complaint management
    Route::apiResource('comp_categories', CompCategoryController::class);
    Route::apiResource('comp_actions', CompActionController::class);
    Route::apiResource('complaint_books', ComplaintBookController::class);
    Route::apiResource('comp_action_logs', CompActionLogController::class);
    Route::get('/complaints/filter', [FilterController::class, 'filterComplaints']);
    Route::get('/complaints/pdf', [FilterController::class, 'generateComplaintPDF']);
    Route::get('/categories/filter', [FilterController::class, 'filterCategories']);
    Route::get('/actions/filter', [FilterController::class, 'filterActions']);
    Route::get('/action-logs/filter', [FilterController::class, 'filterActionLogs']);

    // Complaint gallery
    Route::get('comp_gallary', [CompGallaryController::class, 'index']);
    Route::get('comp_gallary/{id}', [CompGallaryController::class, 'show']);
    Route::post('comp_gallary', [CompGallaryController::class, 'store']);
    Route::put('comp_gallary/{id}', [CompGallaryController::class, 'update']);
    Route::delete('comp_gallary/{id}', [CompGallaryController::class, 'destroy']);

    // Meeting management
    Route::apiResource('meeting_books', MeetingBookController::class);
    Route::delete('meeting_books/{id}/documents', [MeetingBookController::class, 'deleteDocuments'])->name('meeting_books.delete_documents');
    Route::apiResource('meeting_invitees', MeetingInviteeController::class);

    // Amenity management
    Route::get('amenity_masters', [AmenityMasterController::class, 'index']);
    Route::get('amenity_masters/{id}', [AmenityMasterController::class, 'show']);
    Route::post('amenity_masters', [AmenityMasterController::class, 'store']);
    Route::put('amenity_masters/{id}', [AmenityMasterController::class, 'update']);
    Route::delete('amenity_masters/{id}', [AmenityMasterController::class, 'delete']);

    Route::get('amenity_configs', [AmenityConfigController::class, 'index']);
    Route::get('amenity_configs/{id}', [AmenityConfigController::class, 'show']);
    Route::post('amenity_configs', [AmenityConfigController::class, 'store']);
    Route::put('amenity_configs/{id}', [AmenityConfigController::class, 'update']);
    Route::delete('amenity_configs/{id}', [AmenityConfigController::class, 'delete']);

    Route::get('amenity_gallaries', [AmenityGallaryController::class, 'index']);
    Route::get('amenity_gallaries/{id}', [AmenityGallaryController::class, 'show']);
    Route::post('amenity_gallaries', [AmenityGallaryController::class, 'store']);
    Route::put('amenity_gallaries/{id}', [AmenityGallaryController::class, 'update']);
    Route::delete('amenity_gallaries/{id}', [AmenityGallaryController::class, 'destroy']);

    Route::get('amenity_bookings', [AmenityBookingController::class, 'index']);
    Route::get('amenity_bookings/{id}', [AmenityBookingController::class, 'show']);
    Route::post('amenity_bookings', [AmenityBookingController::class, 'store']);
    Route::put('amenity_bookings/{id}', [AmenityBookingController::class, 'update']);
    Route::delete('amenity_bookings/{id}', [AmenityBookingController::class, 'destroy']);

    // Vendor and security management
    Route::get('vendor_registers', [VendorRegisterController::class, 'index']);
    Route::get('vendor_registers/{id}', [VendorRegisterController::class, 'show']);
    Route::post('vendor_registers', [VendorRegisterController::class, 'store']);
    Route::put('vendor_registers/{id}', [VendorRegisterController::class, 'update']);
    Route::delete('vendor_registers/{id}', [VendorRegisterController::class, 'destroy']);

    Route::get('guard-categories', [GuardCategoryController::class, 'index']);
    Route::get('guard-categories/{id}', [GuardCategoryController::class, 'show']);
    Route::post('guard-categories', [GuardCategoryController::class, 'store']);
    Route::put('guard-categories/{id}', [GuardCategoryController::class, 'update']);
    Route::delete('guard-categories/{id}', [GuardCategoryController::class, 'destroy']);

    Route::get('security-agencies', [SecurityAgencyController::class, 'index']);
    Route::get('security-agencies/{id}', [SecurityAgencyController::class, 'show']);
    Route::post('security-agencies', [SecurityAgencyController::class, 'store']);
    Route::put('security-agencies/{id}', [SecurityAgencyController::class, 'update']);
    Route::delete('security-agencies/{id}', [SecurityAgencyController::class, 'destroy']);

    Route::get('guard-registrations', [GuardRegistrationController::class, 'index']);
    Route::get('guard-registrations/{id}', [GuardRegistrationController::class, 'show']);
    Route::post('guard-registrations', [GuardRegistrationController::class, 'store']);
    Route::put('guard-registrations/{id}', [GuardRegistrationController::class, 'update']);
    Route::delete('guard-registrations/{id}', [GuardRegistrationController::class, 'destroy']);

    Route::apiResource('duty-points', DutyPointController::class);

    Route::get('guard_duty_registers', [GuardDutyRegisterController::class, 'index']);
    Route::get('guard_duty_registers/{id}', [GuardDutyRegisterController::class, 'show']);
    Route::post('guard_duty_registers', [GuardDutyRegisterController::class, 'store']);
    Route::put('guard_duty_registers/{id}', [GuardDutyRegisterController::class, 'update']);
    Route::delete('guard_duty_registers/{id}', [GuardDutyRegisterController::class, 'destroy']);

    Route::get('guard_duty_attans', [GuardDutyAttanController::class, 'index']);
    Route::get('guard_duty_attans/{id}', [GuardDutyAttanController::class, 'show']);
    Route::post('guard_duty_attans', [GuardDutyAttanController::class, 'store']);
    Route::put('guard_duty_attans/{id}', [GuardDutyAttanController::class, 'update']);
    Route::delete('guard_duty_attans/{id}', [GuardDutyAttanController::class, 'destroy']);

    Route::get('soci_res_attns', [SociResAttnController::class, 'index']);
    Route::get('soci_res_attns/{id}', [SociResAttnController::class, 'show']);
    Route::post('soci_res_attns', [SociResAttnController::class, 'store']);
    Route::put('soci_res_attns/{id}', [SociResAttnController::class, 'update']);
    Route::delete('soci_res_attns/{id}', [SociResAttnController::class, 'destroy']);

    Route::get('gate_masters', [GateMasterController::class, 'index']);
    Route::get('gate_masters/{id}', [GateMasterController::class, 'show']);
    Route::post('gate_masters', [GateMasterController::class, 'store']);
    Route::put('gate_masters/{id}', [GateMasterController::class, 'update']);
    Route::delete('gate_masters/{id}', [GateMasterController::class, 'destroy']);

    // Visitor and service management
    Route::get('visitor_types', [VisitorTypeController::class, 'index']);
    Route::get('visitor_types/{id}', [VisitorTypeController::class, 'show']);
    Route::post('visitor_types', [VisitorTypeController::class, 'store']);
    Route::put('visitor_types/{id}', [VisitorTypeController::class, 'update']);
    Route::delete('visitor_types/{id}', [VisitorTypeController::class, 'destroy']);

    Route::get('/service-categories', [ServiceCategoryController::class, 'index']);
    Route::get('/service-categories/{id}', [ServiceCategoryController::class, 'show']);
    Route::post('/service-categories', [ServiceCategoryController::class, 'store']);
    Route::put('/service-categories/{id}', [ServiceCategoryController::class, 'update']);
    Route::delete('/service-categories/{id}', [ServiceCategoryController::class, 'destroy']);

    Route::get('freelancer_registers', [FreelancerRegisterController::class, 'index']);
    Route::get('freelancer_registers/{id}', [FreelancerRegisterController::class, 'show']);
    Route::post('freelancer_registers', [FreelancerRegisterController::class, 'store']);
    Route::put('freelancer_registers/{id}', [FreelancerRegisterController::class, 'update']);
    Route::delete('freelancer_registers/{id}', [FreelancerRegisterController::class, 'destroy']);

    Route::get('free_l_serv_links', [FreeLServLinkController::class, 'index']);
    Route::get('free_l_serv_links/{id}', [FreeLServLinkController::class, 'show']);
    Route::post('free_l_serv_links', [FreeLServLinkController::class, 'store']);
    Route::put('free_l_serv_links/{id}', [FreeLServLinkController::class, 'update']);
    Route::delete('free_l_serv_links/{id}', [FreeLServLinkController::class, 'destroy']);

    Route::get('free_l_pack_masts', [FreeLPackMastController::class, 'index']);
    Route::get('free_l_pack_masts/{id}', [FreeLPackMastController::class, 'show']);
    Route::post('free_l_pack_masts', [FreeLPackMastController::class, 'store']);
    Route::put('free_l_pack_masts/{id}', [FreeLPackMastController::class, 'update']);
    Route::delete('free_l_pack_masts/{id}', [FreeLPackMastController::class, 'destroy']);

    Route::get('free_l_serv_offers', [FreeLServOfferController::class, 'index']);
    Route::get('free_l_serv_offers/{id}', [FreeLServOfferController::class, 'show']);
    Route::post('free_l_serv_offers', [FreeLServOfferController::class, 'store']);
    Route::put('free_l_serv_offers/{id}', [FreeLServOfferController::class, 'update']);
    Route::delete('free_l_serv_offers/{id}', [FreeLServOfferController::class, 'destroy']);

    Route::get('free_l_ratings', [FreeLRatingController::class, 'index']);
    Route::get('free_l_ratings/{id}', [FreeLRatingController::class, 'show']);
    Route::post('free_l_ratings', [FreeLRatingController::class, 'store']);
    Route::put('free_l_ratings/{id}', [FreeLRatingController::class, 'update']);
    Route::delete('free_l_ratings/{id}', [FreeLRatingController::class, 'destroy']);

    Route::get('free_l_classsifieds', [FreeLClasssifiedController::class, 'index']);
    Route::get('free_l_classsifieds/{id}', [FreeLClasssifiedController::class, 'show']);
    Route::post('free_l_classsifieds', [FreeLClasssifiedController::class, 'store']);
    Route::put('free_l_classsifieds/{id}', [FreeLClasssifiedController::class, 'update']);
    Route::delete('free_l_classsifieds/{id}', [FreeLClasssifiedController::class, 'destroy']);

    Route::get('classi_gallaries', [ClassiGallaryController::class, 'index']);
    Route::get('classi_gallaries/{id}', [ClassiGallaryController::class, 'show']);
    Route::post('classi_gallaries', [ClassiGallaryController::class, 'store']);
    Route::put('classi_gallaries/{id}', [ClassiGallaryController::class, 'update']);
    Route::delete('classi_gallaries/{id}', [ClassiGallaryController::class, 'destroy']);

    // Visitor management
    Route::apiResource('visitor-register', VisitorRegisterController::class);
    Route::get('/visitors/filter', [VisitorRegisterController::class, 'filterVisitors']);
    Route::get('/visitors/pdf', [VisitorRegisterController::class, 'generateVisitorPDF']);
    Route::get('/filterVisitorEntryLogs', [VisitorRegisterController::class, 'filterVisitorEntryLogs']);
    Route::get('/generateVisitorEntryPDF', [VisitorRegisterController::class, 'generateVisitorEntryPDF']);

    // Parking management
    Route::apiResource('parking-types', ParkingTypeController::class);
    Route::apiResource('parking-levels', ParkingLevelController::class);
    Route::apiResource('parking-slots', ParkingSlotController::class);

    Route::prefix('parking-masters')->group(function () {
        Route::get('/', [ParkingMasterController::class, 'index']);
        Route::post('/', [ParkingMasterController::class, 'store']);
        Route::get('/{id}', [ParkingMasterController::class, 'show']);
        Route::put('/{id}', [ParkingMasterController::class, 'update']);
        Route::delete('/{id}', [ParkingMasterController::class, 'destroy']);
    });

    Route::prefix('vehicle')->group(function () {
        Route::get('/', [VehicleMasterController::class, 'index']);
        Route::get('/{id}', [VehicleMasterController::class, 'show']);
        Route::post('/', [VehicleMasterController::class, 'store']);
        Route::put('/{id}', [VehicleMasterController::class, 'update']);
        Route::delete('/{id}', [VehicleMasterController::class, 'destroy']);
        Route::delete('/{id}/images', [VehicleMasterController::class, 'deleteImages']);
    });

    // Financial management
    Route::apiResource('co-masters', CoMasterController::class);
    Route::apiResource('branch-ms', BranchMController::class);
    Route::apiResource('ledg-grps', LedgGrpController::class);
    Route::apiResource('prty-masts', PrtyMastController::class);
    Route::apiResource('finan-trns', FinanTrnController::class);
    Route::apiResource('sub-finan-trns', SubFinanTrnController::class);
    Route::get('/financial-summary', [FinanTrnController::class, 'getFinancialSummary']);
    Route::post('finan-trns/single', [FinanTrnController::class, 'storeSingle']);
    Route::get('/transaction-details', [FinanTrnController::class, 'getTransactionDetails']);

    Route::prefix('fees-transactions')->group(function () {
        Route::get('/', [FeeTransactionController::class, 'index']);
        Route::get('/{id}', [FeeTransactionController::class, 'show']);
        Route::post('/', [FeeTransactionController::class, 'store']);
        Route::put('/{id}', [FeeTransactionController::class, 'update']);
        Route::delete('/{id}', [FeeTransactionController::class, 'destroy']);
    });

Route::apiResource('discount-types', DiscountTypeController::class);
Route::apiResource('disc-crieterias', DiscCrieteriaController::class);
Route::apiResource('disc-units', DiscUnitController::class);
Route::apiResource('disc-cond-masts', DiscCondMastController::class);
Route::apiResource('package-masters', PackageMasterController::class);
Route::apiResource('discount-masters', DiscountMasterController::class);
Route::apiResource('sco-packages', ScoPackageController::class);
Route::apiResource('sco-disc-maps', ScoDiscMapController::class);
});





