<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Visitor Register Report</title>
    <style>
        body {
            font-family: Arial, Helvetica, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #ffffff;
            color: #333333;
        }
        .header {
            background-color: #2c3e50;
            color: #ffffff;
            padding: 15px;
            text-align: center;
            border-bottom: 2px solid #3498db;
            margin-bottom: 15px;
        }
        .header h1 {
            margin: 0;
            font-size: 22px;
            font-weight: bold;
            text-transform: uppercase;
        }
        .header p {
            margin: 5px 0 0;
            font-size: 11px;
        }
        .container {
            padding: 15px;
            width: 100%;
            margin: 0 auto;
            background-color: #ffffff;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        }
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 9px; /* Smaller font for better fit */
            border: 1px solid #dddddd;
        }
        th, td {
            border: 1px solid #dddddd;
            padding: 6px;
            text-align: left;
            word-wrap: break-word;
            overflow-wrap: break-word;
            vertical-align: top;
        }
        th {
            background-color: #ecf0f1;
            font-weight: bold;
            color: #2c3e50;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            white-space: nowrap;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        tr:hover {
            background-color: #eef2f7;
        }
        .footer {
            text-align: center;
            padding: 8px;
            font-size: 9px;
            color: #7f8c8d;
            border-top: 1px solid #dddddd;
            margin-top: 15px;
        }
        /* Adjusted column widths to sum to 100% */
        th:nth-child(1), td:nth-child(1) { width: 8%; } /* ID */
        th:nth-child(2), td:nth-child(2) { width: 12%; } /* Reg Date */
        th:nth-child(3), td:nth-child(3) { width: 15%; } /* Name */
        th:nth-child(4), td:nth-child(4) { width: 10%; } /* Visit Mode */
        th:nth-child(5), td:nth-child(5) { width: 15%; } /* Purpose */
        th:nth-child(6), td:nth-child(6) { width: 10%; } /* Vehicle */
        th:nth-child(7), td:nth-child(7) { width: 10%; } /* Start Date */
        th:nth-child(8), td:nth-child(8) { width: 10%; } /* End Date */
        th:nth-child(9), td:nth-child(9) { width: 10%; } /* Approved By */
    </style>
</head>
<body>
    <div class="header">
        <h1>Visitor Register Report</h1>
        <p>Society Name Placeholder | Generated: {{ date('h:i A IST, F d, Y') }} ({{ date('h:i A IST') }})</p>
    </div>
    <div class="container">
        @if ($visitors->isEmpty())
            <p style="text-align: center; color: #7f8c8d; font-size: 12px;">No visitors found.</p>
        @else
            <table>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Reg Date</th>
                        <th>Name</th>
                        <th>Visit Mode</th>
                        <th>Purpose</th>
                        <th>Vehicle</th>
                        <th>Start Date</th>
                        <th>End Date</th>
                        <th>Approved By</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($visitors as $visitor)
                        <tr>
                            <td>{{ $visitor->VR_Id }}</td>
                            <td>{{ $visitor->Vr_RegDate ?? 'N/A' }}</td>
                            <td>{{ $visitor->Vr_Name ?? 'N/A' }}</td>
                            <td>{{ $visitor->Visit_Mode ?? 'N/A' }}</td>
                            <td>{{ $visitor->Vr_Purpose ?? 'N/A' }}</td>
                            <td>{{ $visitor->VR_Vehicle ?? 'N/A' }}</td>
                            <td>{{ $visitor->Vr_StDate ?? 'N/A' }}</td>
                            <td>{{ $visitor->Vr_EdDate ?? 'N/A' }}</td>
                            <td>{{ $visitor->approvedBy ? $visitor->approvedBy->name ?? 'N/A' : 'N/A' }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        @endif
    </div>
    <div class="footer">
        Generated on: {{ date('h:i A IST, F d, Y') }} | Page 1 of 1
    </div>
</body>
</html>
