<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Complaints Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #ffffff;
            color: #333333;
        }
        .header {
            background-color: #2c3e50;
            color: #ffffff;
            padding: 15px;
            text-align: center;
            border-bottom: 2px solid #3498db;
            margin-bottom: 15px;
        }
        .header h1 {
            margin: 0;
            font-size: 22px;
            font-weight: bold;
            text-transform: uppercase;
        }
        .header p {
            margin: 5px 0 0;
            font-size: 11px;
        }
        .container {
            padding: 15px;
            width: 100%;
            margin: 0 auto;
            background-color: #ffffff;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        }
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 9px;
            border: 1px solid #dddddd;
        }
        th, td {
            border: 1px solid #dddddd;
            padding: 6px;
            text-align: left;
            word-wrap: break-word;
            overflow-wrap: break-word;
            vertical-align: top;
        }
        th {
            background-color: #ecf0f1;
            font-weight: bold;
            color: #2c3e50;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            white-space: nowrap;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        tr:hover {
            background-color: #eef2f7;
        }
        .footer {
            text-align: center;
            padding: 8px;
            font-size: 9px;
            color: #7f8c8d;
            border-top: 1px solid #dddddd;
            margin-top: 15px;
        }
        /* Adjusted column widths to sum to 100% */
        th:nth-child(1), td:nth-child(1) { width: 10%; } /* ID */
        th:nth-child(2), td:nth-child(2) { width: 15%; } /* Title */
        th:nth-child(3), td:nth-child(3) { width: 20%; } /* Description */
        th:nth-child(4), td:nth-child(4) { width: 15%; } /* Category */
        th:nth-child(5), td:nth-child(5) { width: 15%; } /* User */
        th:nth-child(6), td:nth-child(6) { width: 10%; } /* Status */
        th:nth-child(7), td:nth-child(7) { width: 15%; } /* Complaint Type */
    </style>
</head>
<body>
    <div class="header">
        <h1>Complaints Report</h1>
        <p>{{ $socName }} | Generated: {{ date('h:i A IST, F d, Y') }} ({{ date('h:i A IST') }})</p>
    </div>
    <div class="container">
        @if ($complaints->isEmpty())
            <p style="text-align: center; color: #7f8c8d; font-size: 12px;">No complaints found.</p>
        @else
            <table>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Title</th>
                        <th>Description</th>
                        <th>Category</th>
                        <th>User</th>
                        <th>Status</th>
                        <th>Complaint Type</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($complaints as $complaint)
                        <tr>
                            <td>{{ $complaint->Cmp_Id }}</td>
                            <td>{{ $complaint->Title ?? 'N/A' }}</td>
                            <td>{{ $complaint->Description ?? 'N/A' }}</td>
                            <td>{{ $complaint->category ? $complaint->category->CC_Desc ?? 'N/A' : 'N/A' }}</td>
                            <td>{{ $complaint->user ? $complaint->user->name ?? 'N/A' : 'N/A' }}</td>
                            <td>{{ $complaint->Status ?? 'N/A' }}</td>
                            <td>{{ $complaint->CompType ?? 'N/A' }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        @endif
    </div>
    <div class="footer">
        Generated on: {{ date('h:i A IST, F d, Y') }} | Page 1 of 1
    </div>
</body>
</html>
