<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('sco_disc_maps', function (Blueprint $table) {
            $table->bigIncrements('ScoDisID')->comment('Primary Key');
            $table->bigInteger('SocId')->unsigned()->comment('Foreign Key to SocietyMaster');
            $table->bigInteger('DiscID')->unsigned()->comment('Foreign Key to DiscountMaster');
            $table->date('Start_Date')->comment('Discount Start Date');
            $table->date('Valid_Date')->comment('Discount Valid Until Date');
            $table->char('Status', 1)->comment('Status (e.g., A=Active, I=Inactive)');
            $table->timestamps();

            $table->foreign('SocId')->references('SocId')->on('society_master')->onDelete('cascade');
            $table->foreign('DiscID')->references('DiscID')->on('discount_masters')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('sco_disc_maps');
    }
};
