<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('sco_packages', function (Blueprint $table) {
            $table->bigIncrements('ScoPck_Id')->comment('Primary Key');
            $table->bigInteger('SocId')->unsigned()->comment('Foreign Key to Societies');
            $table->bigInteger('PackageId')->unsigned()->comment('Foreign Key to PackageMaster');
            $table->date('Start_Date')->comment('Package Start Date');
            $table->date('Valid_Date')->comment('Package Valid Until Date');
            $table->char('Status', 1)->comment('Status (e.g., A=Active, I=Inactive)');
            $table->timestamps();

            $table->foreign('SocId')->references('SocId')->on('society_master')->onDelete('restrict');
            $table->foreign('PackageId')->references('PackageId')->on('package_masters')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('sco_packages');
    }
};
