<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('package_module_links', function (Blueprint $table) {
            $table->bigIncrements('PMLinkID')->comment('Primary Key');
            $table->bigInteger('PackageId')->unsigned()->comment('Foreign Key to PackageMaster');
            $table->bigInteger('ModuleID')->unsigned()->comment('Foreign Key to Modules');
            $table->decimal('ModuleFixPrice', 10, 2)->comment('Fixed Price for Module');
            $table->integer('ModuleFreeUsers')->comment('Number of Free Users for Module');
            $table->decimal('ExtraUserFees', 10, 2)->comment('Fees for Extra Users');
            $table->integer('MarginShare')->comment('Margin Share Percentage');
            $table->timestamps();

            $table->foreign('PackageId')->references('PackageId')->on('package_masters')->onDelete('cascade');
            $table->foreign('ModuleID')->references('ModuleID')->on('module_master')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('package_module_links');
    }
};
