<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('discount_masters', function (Blueprint $table) {
            $table->bigIncrements('DiscID')->comment('Primary Key');
            $table->bigInteger('DiscTID')->unsigned()->comment('Foreign Key to DiscountType');
            $table->string('DiscountName', 25)->comment('Discount Name');
            $table->bigInteger('DiscCriID')->unsigned()->comment('Foreign Key to DiscCrieteria');
            $table->decimal('Cri_Vale', 10, 2)->comment('Criteria Value');
            $table->decimal('Disc_Value', 10, 2)->comment('Discount Value');
            $table->bigInteger('DiscCMast')->unsigned()->comment('Foreign Key to DiscCondMast');
            $table->bigInteger('DiscUId')->unsigned()->comment('Foreign Key to DiscUnits');
            $table->dateTime('D_Valid_From')->comment('Discount Valid From Date');
            $table->dateTime('D_Valid_To')->comment('Discount Valid To Date');
            $table->string('D_Apply_To', 25)->comment('Discount Applies To');
            $table->char('Disc_Clubbed', 1)->comment('Clubbed Discount (Y/N)');
            $table->char('Status', 1)->comment('Status (e.g., A=Active, I=Inactive)');
            $table->timestamps();

            $table->foreign('DiscTID')->references('DiscTID')->on('discount_types')->onDelete('cascade');
            $table->foreign('DiscCriID')->references('DiscCriID')->on('disc_crieterias')->onDelete('cascade');
            $table->foreign('DiscCMast')->references('DiscCMast')->on('disc_cond_masts')->onDelete('cascade');
            $table->foreign('DiscUId')->references('DiscUID')->on('disc_units')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('discount_masters');
    }
};
