<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('package_masters', function (Blueprint $table) {
            $table->bigIncrements('PackageId')->comment('Primary Key');
            $table->string('PackageName', 50)->comment('Package Name');
            $table->string('Description', 255)->comment('Package Description');
            $table->char('Status', 1)->comment('Package Status (e.g., A=Active, I=Inactive)');
            $table->decimal('PackFixPrice', 10, 2)->comment('Fixed Price of Package');
            $table->integer('PackFreeUsers')->comment('Number of Free Users Included');
            $table->decimal('ExtraUserFees', 10, 2)->comment('Fees for Extra Users');
            $table->integer('ValidityDays')->comment('Validity Period in Days');
            $table->char('AutoRenew', 1)->comment('Auto Renew Status (e.g., Y=Yes, N=No)');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('package_masters');
    }
};
