<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
   public function up(): void
    {
        Schema::table('unit_members_link', function (Blueprint $table) {
            $table->tinyInteger('Us_Admin')->nullable();
            $table->unsignedBigInteger('MemRel_Id')->nullable();
            $table->tinyInteger('PrivecyMode')->nullable();

            $table->foreign('MemRel_Id')->references('MemRel_Id')->on('relation_master')->onDelete('restrict');
        });
    }

    public function down(): void
    {
        Schema::table('unit_members_link', function (Blueprint $table) {
            $table->dropForeign(['MemRel_Id']);
            $table->dropColumn(['Us_Admin', 'MemRel_Id', 'PrivecyMode']);
        });
    }
};
