<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('users_master', function (Blueprint $table) {
            $table->unsignedBigInteger('SocId')->nullable()->after('U_Id');
            $table->foreign('SocId')->references('SocId')->on('society_master')->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::table('users_master', function (Blueprint $table) {
            $table->dropForeign(['SocId']);
            $table->dropColumn('SocId');
        });
    }
};
