<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('fees_transactions', function (Blueprint $table) {
            $table->bigIncrements('FT_Id');
            $table->dateTime('Ft_Date');
            $table->unsignedBigInteger('SocId')->nullable();
            $table->string('Ft_VouTy', 3)->in('REC', 'PAY', 'DN', 'CN');
            $table->string('Ft_VouNo', 10);
            $table->unsignedBigInteger('Ft_SrNo');
            $table->unsignedBigInteger('AccId')->nullable();
            $table->unsignedBigInteger('FC_Id')->nullable();
            $table->unsignedBigInteger('SU_Id')->nullable();
            $table->string('Chq_No')->nullable();
            $table->date('Chq_Dt')->nullable();
            $table->decimal('Cr_Amount', 10, 2)->nullable();
            $table->decimal('Dr_Amount', 10, 2)->nullable();
            $table->string('Ref_VouNo', 10)->nullable();
            $table->string('Approved_By')->nullable();
            $table->date('Approved_Date')->nullable();
            $table->string('Description', 25)->nullable();
            $table->timestamps();

              $table->foreign('FC_Id')->references('FC_Id')->on('fees_config')->onDelete('set null');
             $table->foreign('SU_Id')->references('SU_Id')->on('soc_units')->onDelete('set null');
             $table->foreign('SocId')->references('SocId')->on('society_master')->onDelete('set null');
              $table->foreign('AccId')->references('Pr_Id')->on('prty_masts')->onDelete('set null');

        });
    }

    public function down(): void
    {
        Schema::dropIfExists('fees_transactions');
    }
};
