<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('fees_config', function (Blueprint $table) {
            $table->unsignedBigInteger('SU_ID')->nullable()->after('SocId');
            $table->foreign('SU_ID')->references('SU_ID')->on('soc_units')->onDelete('restrict');
        });
    }

    public function down(): void
    {
        Schema::table('fees_config', function (Blueprint $table) {
            $table->dropForeign(['SU_ID']);
            $table->dropColumn('SU_ID');
        });
    }
};
