<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('fees_config', function (Blueprint $table) {
            $table->date('Due_Date')->nullable()->after('Start_Date');
            $table->enum('Per_Uni_Type', ['sqrt', 'unit', 'lumsum'])->nullable()->after('Amount');
        });
    }

    public function down(): void
    {
        Schema::table('fees_config', function (Blueprint $table) {
            $table->dropColumn(['Due_Date', 'Per_Uni_Type']);
        });
    }
};
