<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('co_masters', function (Blueprint $table) {
            $table->id('Co_Id'); // Auto-incrementing primary key
            $table->string('co_grp', 5);
            $table->string('co_nam', 40);
            $table->string('co_ad1', 40)->nullable();
            $table->string('co_ad2', 40)->nullable();
            $table->string('co_cty', 33)->nullable();
            $table->string('co_pin', 7)->nullable();
            $table->string('co_phn', 40)->nullable();
            $table->string('co_eml', 40)->nullable();
            $table->string('co_url', 40)->nullable();
            $table->string('co_pan', 20)->nullable();
            $table->string('co_tds', 20)->nullable();
            $table->string('co_pac', 20)->nullable();
            $table->string('co_tdc', 20)->nullable();
            $table->string('co_lic', 20)->nullable();
            $table->string('co_reg', 20)->nullable();
            $table->string('co_st_n', 40)->nullable();
            $table->string('co_cst', 40)->nullable();
            $table->string('co_vat', 40)->nullable();
            $table->string('co_ecc', 40)->nullable();
            $table->string('co_exc', 20)->nullable();
            $table->string('co_rng', 20)->nullable();
            $table->string('tr_mod', 1)->nullable();
            $table->decimal('co_bak', 18, 0);
            $table->string('co_ent', 1)->nullable();
            $table->string('co_typ', 1)->nullable();
            $table->dateTime('lst_bk')->nullable();
            $table->string('bs_typ', 1)->nullable();
            $table->decimal('co_qty', 18, 0)->nullable();
            $table->string('co_pss', 7);
            $table->integer('op_id')->nullable();
            $table->string('dt_tm', 10)->nullable();
            $table->string('logo', 200)->nullable();
            $table->string('dept_id', 50)->nullable();

            $table->unique(['co_grp', 'Co_Id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('co_masters');
    }
};
