<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('unit_members_link', function (Blueprint $table) {
            $table->unsignedBigInteger('SocId')->nullable()->after('SUM_Id');
            $table->foreign('SocId')->references('SocId')->on('society_master')->onDelete('restrict');
        });
    }

    public function down(): void
    {
        Schema::table('unit_members_link', function (Blueprint $table) {
            $table->dropForeign(['SocId']);
            $table->dropColumn('SocId');
        });
    }
};
