<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddScpIdAndActiveDateToVehiclesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('vehicles', function (Blueprint $table) {
            $table->bigInteger('SCP_Id')->unsigned()->nullable()->after('Vehicle_Id'); // Nullable foreign key
            $table->timestamp('ActiveDate')->nullable()->after('Status'); // Nullable DateTime
            $table->foreign('SCP_Id')->references('SCP_Id')->on('parking_masters')->onDelete('set null'); // Assuming society_car_parks table
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('vehicles', function (Blueprint $table) {
            $table->dropForeign(['SCP_Id']);
            $table->dropColumn(['SCP_Id', 'ActiveDate']);
        });
    }
}
