<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVehiclesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('vehicles', function (Blueprint $table) {
            $table->bigIncrements('Vehicle_Id'); // bigint(20) UNSIGNED, AUTO_INCREMENT, Primary Key
            $table->bigInteger('SU_Id')->unsigned()->nullable(); // bigint(20) UNSIGNED, Nullable
            $table->bigInteger('SocId')->unsigned()->nullable(); // bigint(20) UNSIGNED, Nullable
            $table->string('VehicleRegNo', 25)->nullable(); // varchar(25), Nullable
            $table->enum('Status', ['Active', 'Inactive'])->default('Active'); // enum, Not Nullable, Default 'Active'
            $table->string('Vehicle_Type', 255)->nullable(); // varchar(255), Nullable
            $table->string('Vehicle_Model', 50)->nullable(); // varchar(50), Nullable
            $table->string('Vehicle_Brand', 50)->nullable(); // varchar(50), Nullable
            $table->longText('Vehicle_Img')->nullable(); // longtext, Nullable
            $table->timestamp('CreatedAt')->useCurrent(); // timestamp, Not Nullable, Default CURRENT_TIMESTAMP

            // Indexes
            $table->index('SU_Id');
            $table->index('SocId');
            $table->index('VehicleRegNo');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vehicles');
    }
}
