<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('parking_masters', function (Blueprint $table) {
            $table->bigIncrements('SCP_Id');
            $table->string('SCP_Desc', 100);
            $table->char('Status', 1);
            $table->dateTime('ActiveDate');
            $table->dateTime('ValidDate');
            $table->bigInteger('SR_Id')->unsigned()->nullable();
            $table->bigInteger('PS_ID')->unsigned()->nullable();
            $table->bigInteger('SU_ID')->unsigned()->nullable();
            $table->bigInteger('Asgn_By')->unsigned()->nullable();
            $table->timestamps();

            // Foreign key constraints
            $table->foreign('SR_Id')->references('SR_Id')->on('soci_reso_books')->onDelete('set null');
            $table->foreign('PS_ID')->references('PS_ID')->on('parking_slots')->onDelete('set null');
            $table->foreign('SU_ID')->references('SU_ID')->on('soc_units')->onDelete('set null');
            $table->foreign('Asgn_By')->references('U_Id')->on('users_master')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('parking_masters');
    }
};
