<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCompGallaryTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('comp_gallary', function (Blueprint $table) {
            $table->bigIncrements('Cg_Id');  // Primary key
            $table->unsignedBigInteger('Cmp_Id');  // Foreign key to ComplaintBook
            $table->json('Image');  // Storing multiple images as JSON
            $table->dateTime('Img_Date');  // Image upload date
            $table->unsignedBigInteger('U_Id');  // Foreign key to Users
            $table->string('Img_Status', 1);  // 'A' for active, 'I' for inactive
            $table->timestamps();  // created_at, updated_at timestamps

            // Foreign Key Constraints
            $table->foreign('Cmp_Id')->references('Cmp_Id')->on('complaint_books')->onDelete('cascade');
            $table->foreign('U_Id')->references('U_Id')->on('users_master')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::dropIfExists('comp_gallary');
    }
}
