<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('parking_slots', function (Blueprint $table) {
            $table->bigIncrements('PS_ID'); // Primary key
            $table->bigInteger('PL_Id')->unsigned(); // Foreign key
            $table->bigInteger('PT_ID')->unsigned(); // Foreign key
            $table->string('PS_No', 5); // Varchar(5)
            $table->timestamps();

            // Assuming foreign keys reference other tables
            $table->foreign('PL_Id')->references('PL_Id')->on('parking_levels')->onDelete('cascade');
            $table->foreign('PT_ID')->references('PT_ID')->on('parking_types')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('parking_slots');
    }
};
?>
