<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateParkingLevelsTable extends Migration
{
    public function up()
    {
        Schema::create('parking_levels', function (Blueprint $table) {
            $table->bigIncrements('PL_Id'); // bigint(20) primary key, auto-incrementing
            $table->string('Level_Desc', 100); // varchar(100), not null
            $table->bigInteger('SocId')->unsigned()->nullable(); // nullable foreign key
            $table->foreign('SocId')->references('SocId')->on('society_master')->onDelete('set null');
            $table->timestamps(); // created_at and updated_at
        });
    }

    public function down()
    {
        Schema::dropIfExists('parking_levels');
    }
}
