<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class RemoveUniqueIndexFromSocBlock extends Migration
{
    public function up(): void
    {
        Schema::table('soc_block', function (Blueprint $table) {
            // Drop the unique index named 'soc_block_unique'
            $table->dropUnique('soc_block_unique');
        });
    }

    public function down(): void
    {
        Schema::table('soc_block', function (Blueprint $table) {
            // Re-add the unique index in case of rollback
            $table->unique(['SB_Name', 'Sd_Id'], 'soc_block_unique');
        });
    }
}
