<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class RemoveUniqueIndexFromUnitTypes extends Migration
{
    public function up(): void
    {
        Schema::table('unit_types', function (Blueprint $table) {
            // Drop the unique index named 'unit_type_name_unique'
            $table->dropUnique('unit_type_name_unique');
        });
    }

    public function down(): void
    {
        Schema::table('unit_types', function (Blueprint $table) {
            // Re-add the unique index in case of rollback
            $table->unique('UT_Name', 'unit_type_name_unique');
        });
    }
}
