<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class RemoveUniqueIndexFromSociDivisions extends Migration
{
    public function up()
    {
        Schema::table('soci_divisions', function (Blueprint $table) {
            // Drop the unique index named 'soci_division_unique'
            $table->dropUnique('soci_division_unique');
        });
    }

    public function down()
    {
        Schema::table('soci_divisions', function (Blueprint $table) {
            // Re-add the unique index in case of rollback
            $table->unique(['Sd_Name', 'SocId'], 'soci_division_unique');
        });
    }
}
