<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVisitorRegisterTable extends Migration
{
    public function up()
    {
        Schema::create('visitor_register', function (Blueprint $table) {
            $table->bigIncrements('VR_Id');
            $table->bigInteger('SocId')->unsigned();
            $table->date('Vr_RegDate'); // Changed to DATE
            $table->string('Vr_Name', 50);
            $table->string('Vr_Co_Name', 50)->nullable();
            $table->bigInteger('VT_Id')->unsigned();
            $table->bigInteger('VrU_Id')->unsigned();
            $table->string('Visit_Mode', 1);
            $table->string('Vr_Purpose', 255)->nullable();
            $table->string('VR_Vehicle', 25)->nullable();
            $table->date('Vr_StDate'); // Changed to DATE
            $table->date('Vr_EdDate')->nullable(); // Changed to DATE
            $table->string('Vr_Apr_Stt', 1);
            $table->bigInteger('Vr_Apr_By')->unsigned()->nullable();
            $table->time('Vr_Ent_DT')->nullable(); // Changed to TIME
            $table->time('Vr_Est_Tm')->nullable(); // Changed to TIME
            $table->time('Vr_Ext_DT')->nullable(); // Changed to TIME
            $table->bigInteger('Vr_Ent_Gt')->unsigned()->nullable();
            $table->bigInteger('Vr_Ext_Gt')->unsigned()->nullable();
            $table->integer('Vr_Noof_Vst')->default(1);
            $table->json('Vr_In_Pic')->nullable();
            $table->json('Vr_Out_Pic')->nullable();
            $table->bigInteger('Vr_End_Qr')->nullable();
            $table->bigInteger('Vr_Exit_Qr')->nullable();
            $table->string('OTP', 10)->nullable();
            $table->string('Vr_Status', 1);
            $table->timestamps();

            // Foreign key constraints
            $table->foreign('SocId')->references('SocId')->on('society_master')->onDelete('cascade');
            $table->foreign('VT_Id')->references('VT_Id')->on('visitor_type')->onDelete('cascade');
            $table->foreign('VrU_Id')->references('U_Id')->on('users_master')->onDelete('cascade');
            $table->foreign('Vr_Apr_By')->references('U_Id')->on('users_master')->onDelete('set null');
            $table->foreign('Vr_Ent_Gt')->references('GM_ID')->on('gate_master')->onDelete('set null');
            $table->foreign('Vr_Ext_Gt')->references('GM_ID')->on('gate_master')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::dropIfExists('visitor_register');
    }
}
