<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClassiGallaryTable extends Migration
{
    public function up()
    {
        Schema::create('classi_gallary', function (Blueprint $table) {
            $table->bigIncrements('Clg_Id');
            $table->unsignedBigInteger('FLC_Id');
            $table->json('Image');
            $table->dateTime('Img_Date');
            $table->unsignedBigInteger('Img_U_Id');
            $table->string('Img_Status', 1);
            $table->timestamps();

            $table->foreign('FLC_Id')->references('FLC_Id')->on('free_l_classsified')->onDelete('cascade');
            $table->foreign('Img_U_Id')->references('U_Id')->on('users_master')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('classi_gallary');
    }
}
