<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFreeLRatingTable extends Migration
{
    public function up()
    {
        Schema::create('free_l_rating', function (Blueprint $table) {
            $table->bigIncrements('FLR_Id');
            $table->unsignedBigInteger('FL_Id');
            $table->unsignedBigInteger('U_Id');
            $table->tinyInteger('Status');
            $table->timestamps();

            $table->foreign('FL_Id')->references('FL_Id')->on('freelancer_register')->onDelete('cascade');
            $table->foreign('U_Id')->references('U_Id')->on('users_master')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('free_l_rating');
    }
}
