<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFreeLServOfferTable extends Migration
{
    public function up()
    {
        Schema::create('free_l_serv_offer', function (Blueprint $table) {
            $table->bigIncrements('FLPL_Id');
            $table->unsignedBigInteger('FLP_Id')->nullable();
            $table->unsignedBigInteger('FL_Id')->nullable();
            $table->dateTime('STDate')->nullable();
            $table->dateTime('EdDate')->nullable();
            $table->string('Status', 1)->nullable();
            $table->timestamps();

            $table->foreign('FLP_Id')->references('FLP_Id')->on('free_l_pack_mast')->onDelete('set null');
            $table->foreign('FL_Id')->references('FL_Id')->on('freelancer_register')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::dropIfExists('free_l_serv_offer');
    }
}
