<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFreeLPackMastTable extends Migration
{
    public function up()
    {
        Schema::create('free_l_pack_mast', function (Blueprint $table) {
            $table->bigIncrements('FLP_Id');
            $table->string('FLP_Desc', 25);
            $table->decimal('FLP_Qty', 10, 2);
            $table->decimal('FLP_Rate', 10, 2);
            $table->unsignedBigInteger('SocId');
            $table->string('FLP_Type', 1)->nullable();
            $table->timestamps();

            $table->foreign('SocId')->references('SocId')->on('society_master')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('free_l_pack_mast');
    }
}
