<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFreeLServLinkTable extends Migration
{
    public function up()
    {
        Schema::create('free_l_serv_link', function (Blueprint $table) {
            $table->bigIncrements('FLSr_ID');
            $table->unsignedBigInteger('Srv_Id');
            $table->unsignedBigInteger('FL_Id');
            $table->string('ListPriority', 1)->nullable();
            $table->timestamps();

            $table->foreign('Srv_Id')->references('srv_id')->on('service_categories')->onDelete('cascade');
            $table->foreign('FL_Id')->references('FL_Id')->on('freelancer_register')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('free_l_serv_link');
    }
}
