<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFreelancerRegisterTable extends Migration
{
    public function up()
    {
        Schema::create('freelancer_register', function (Blueprint $table) {
            $table->bigIncrements('FL_Id');
            $table->unsignedBigInteger('SocId');
            $table->unsignedBigInteger('U_Id');
            $table->unsignedBigInteger('SR_Id')->nullable();
            $table->string('BusinessName', 255);
            $table->string('Registration', 25);
            $table->string('TaxRegistration', 25);
            $table->dateTime('STDate')->nullable();
            $table->dateTime('EdDate')->nullable();
            $table->string('Status', 1)->nullable();
            $table->timestamps();

            $table->foreign('SocId')->references('SocId')->on('society_master')->onDelete('cascade');
            $table->foreign('U_Id')->references('U_Id')->on('users_master')->onDelete('cascade');
            $table->foreign('SR_Id')->references('SR_Id')->on('soci_reso_books')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::dropIfExists('freelancer_register');
    }
}
