<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateGateMasterTable extends Migration
{
    public function up()
    {
        Schema::create('gate_master', function (Blueprint $table) {
            $table->bigIncrements('GM_ID');
            $table->unsignedBigInteger('SocId');
            $table->string('GM_Desc', 255);
            $table->string('Status', 1)->nullable();
            $table->timestamps();

            $table->foreign('SocId')->references('SocId')->on('society_master')->onDelete('restrict');
        });
    }

    public function down()
    {
        Schema::dropIfExists('gate_master');
    }
}
