<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSociResAttnTable extends Migration
{
    public function up()
    {
        Schema::create('soci_res_attn', function (Blueprint $table) {
            $table->bigIncrements('SRA_ID');
            $table->unsignedBigInteger('SR_Id')->nullable();
            $table->unsignedBigInteger('U_Id');
            $table->string('SRU_Conf', 1)->nullable();
            $table->timestamps();

            $table->foreign('SR_Id')->references('SR_Id')->on('soci_reso_books')->onDelete('set null');
            $table->foreign('U_Id')->references('U_Id')->on('users_master')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('soci_res_attn');
    }
}
