<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateGuardDutyAttanTable extends Migration
{
    public function up()
    {
        Schema::create('guard_duty_attan', function (Blueprint $table) {
            $table->bigIncrements('GA_ID');
            $table->unsignedBigInteger('GD_Id');
            $table->time('LoginTime')->nullable();
            $table->time('LogoutTime')->nullable();
            $table->date('LogInDate')->nullable();
            $table->timestamps();

            $table->foreign('GD_Id')->references('GD_Id')->on('guard_duty_register')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('guard_duty_attan');
    }
}
