<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateGuardDutyRegisterTable extends Migration
{
    public function up()
    {
        Schema::create('guard_duty_register', function (Blueprint $table) {
            $table->bigIncrements('GD_Id');
            $table->unsignedBigInteger('GR_Id');
            $table->dateTime('DutyOn')->nullable();
            $table->dateTime('DutyOff')->nullable();
            $table->unsignedBigInteger('DP_Id');
            $table->string('Status', 1)->nullable();
            $table->string('DutyType', 1)->nullable();
            $table->timestamps();

            $table->foreign('GR_Id')->references('GR_Id')->on('guard_registration')->onDelete('cascade');
            $table->foreign('DP_Id')->references('DP_Id')->on('duty_points')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('guard_duty_register');
    }
}
