<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
         Schema::create('guard_registration', function (Blueprint $table) {
            $table->bigIncrements('GR_Id');
            $table->unsignedBigInteger('SA_Id'); // Foreign key to SecurityAgency
            $table->unsignedBigInteger('U_Id');  // Foreign key to Users
            $table->unsignedBigInteger('GC_Id'); // Foreign key to GuardCategory
            $table->timestamps();

            // Foreign key constraints
            $table->foreign('SA_Id')->references('SA_Id')->on('security_agencies')->onDelete('cascade');
            $table->foreign('U_Id')->references('U_Id')->on('users_master')->onDelete('cascade');
            $table->foreign('GC_Id')->references('GC_Id')->on('guard_category')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('guard_registration');
    }
};
