<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
       Schema::create('security_agencies', function (Blueprint $table) {
            $table->bigIncrements('SA_Id');
            $table->unsignedBigInteger('SocId');
            $table->unsignedBigInteger('U_Id');
            $table->unsignedBigInteger('SR_Id');
            $table->string('BusinessName');
            $table->string('Registration', 25);
            $table->string('TaxRegistration', 25);
            $table->dateTime('STDate');
            $table->dateTime('EdDate');
            $table->string('Status', 1);
            $table->timestamps();

            // Foreign Key Constraints
            $table->foreign('SocId')->references('SocId')->on('society_master')->onDelete('cascade');
            $table->foreign('U_Id')->references('U_Id')->on('users_master')->onDelete('cascade');
            $table->foreign('SR_Id')->references('SR_Id')->on('soci_reso_books')->onDelete('cascade'); // Replace with actual table name
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('security_agencies');
    }
};
