<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAmenityBookingsTable extends Migration
{
    public function up()
    {
        Schema::create('amenity_bookings', function (Blueprint $table) {
            $table->bigIncrements('AB_ID');
            $table->unsignedBigInteger('AC_ID');
            $table->unsignedBigInteger('U_Id');
            $table->dateTime('StartDateTime')->nullable();
            $table->dateTime('EndDateTime')->nullable();
            $table->integer('QtyRequested')->nullable();
            $table->integer('QtyBooked')->nullable();
            $table->decimal('Amount', 10, 2)->nullable();
            $table->decimal('EB_Disc', 10, 2)->nullable();
            $table->decimal('Blk_Disc', 10, 2)->nullable();
            $table->decimal('Spl_Cat_Disc', 10, 2)->nullable();
            $table->decimal('Late_Chg', 10, 2)->nullable();
            $table->decimal('Int_Chg', 10, 2)->nullable();
            $table->dateTime('Req_Date')->nullable();
            $table->unsignedBigInteger('Approved_By')->nullable();
            $table->dateTime('Approved_Date')->nullable();
            $table->timestamps();

            $table->foreign('AC_ID')->references('AC_ID')->on('amenity_configs')->onDelete('cascade');
            $table->foreign('U_Id')->references('U_Id')->on('users_master')->onDelete('cascade');
            $table->foreign('Approved_By')->references('U_Id')->on('users_master')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::dropIfExists('amenity_bookings');
    }
}

