<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAmenityGallaryTable extends Migration
{
    public function up()
    {
        Schema::create('amenity_gallary', function (Blueprint $table) {
            $table->bigIncrements('AG_Id');
            $table->unsignedBigInteger('AM_ID');
            $table->json('Image');
            $table->dateTime('Img_Date');
            $table->unsignedBigInteger('Img_U_Id');
            $table->string('Img_Status', 1);
            $table->timestamps();

            $table->foreign('AM_ID')->references('AM_ID')->on('amenity_masters')->onDelete('cascade');
            $table->foreign('Img_U_Id')->references('U_Id')->on('users_master')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('amenity_gallary');
    }
}
