<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAmenityConfigsTable extends Migration
{
    public function up()
    {
        Schema::create('amenity_configs', function (Blueprint $table) {
            $table->bigIncrements('AC_ID');
            $table->unsignedBigInteger('AM_ID');
            $table->unsignedBigInteger('SocId');
            $table->unsignedBigInteger('FC_Id');
            $table->string('Name', 25);
            $table->integer('MaxCapacity');
            $table->string('Status', 1);
            $table->integer('TimeSlot');
            $table->integer('FeesUnit');
            $table->timestamps();

            $table->foreign('AM_ID')->references('AM_ID')->on('amenity_masters')->onDelete('cascade');
            $table->foreign('SocId')->references('SocId')->on('society_master')->onDelete('cascade');
            $table->foreign('FC_Id')->references('FC_Id')->on('fees_config')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('amenity_configs');
    }
}
