<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMeetingInviteesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('meeting_invitees', function (Blueprint $table) {
            $table->bigIncrements('MI_Id');
            $table->unsignedBigInteger('MB_Id'); // Foreign key to MeetingBook
            $table->unsignedBigInteger('U_Id');  // Foreign key to users table
            $table->dateTime('InviteSend')->nullable();
            $table->dateTime('InviteRead')->nullable();
            $table->string('Attend', 1)->nullable(); // 'Y' for Yes, 'N' for No, 'P' for Pending
            $table->timestamps();

            // Foreign Key Constraints
            $table->foreign('MB_Id')->references('MB_Id')->on('meeting_book')->onDelete('cascade');
            $table->foreign('U_Id')->references('U_Id')->on('users_master')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('meeting_invitees');
    }
}
