<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMeetingBookTable extends Migration
{
    public function up()
    {
        Schema::create('meeting_book', function (Blueprint $table) {
            $table->bigIncrements('MB_Id');
            $table->unsignedBigInteger('SocId');
            $table->string('Venue', 25);
            $table->string('Agenda', 250);
            $table->dateTime('STDate');
            $table->dateTime('EdDate');
            $table->dateTime('StTime');
            $table->dateTime('EdTime');
            $table->string('Status', 1);
            $table->timestamps();

            $table->foreign('SocId')->references('SocId')->on('society_master')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('meeting_book');
    }
}
