<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class RecreateCompActionLogTable extends Migration
{
    public function up()
    {
        // Drop the existing table if it exists
        Schema::dropIfExists('comp_action_log');

        // Create the new table
        Schema::create('comp_action_log', function (Blueprint $table) {
            $table->bigIncrements('CA_Sr');
            $table->unsignedBigInteger('Cmp_Id');
            $table->unsignedBigInteger('Act_U_ID');
            $table->unsignedBigInteger('CA_ID');
            $table->string('Ca_Desc', 25);
            $table->timestamps();

            // Foreign Key Constraints
            $table->foreign('Cmp_Id')->references('Cmp_Id')->on('complaint_books')->onDelete('cascade');
            $table->foreign('Act_U_ID')->references('U_Id')->on('users_master')->onDelete('cascade');
            $table->foreign('CA_ID')->references('CA_ID')->on('comp_actions')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('comp_action_log');
    }
}
