<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateComplaintBooksTable extends Migration
{
    public function up()
    {
        Schema::create('complaint_books', function (Blueprint $table) {
            $table->bigIncrements('Cmp_Id');
            $table->unsignedBigInteger('CC_Id');
            $table->unsignedBigInteger('SocId');
            $table->unsignedBigInteger('U_Id');
            $table->string('Title', 25);
            $table->string('Description', 500);
            $table->string('CompType', 1);
            $table->string('Severity', 1);
            $table->string('Status', 1);
            $table->timestamp('InProgre_At')->nullable();
            $table->timestamp('Complited_At')->nullable();
            $table->string('CompMode', 1);
            $table->timestamps();

            $table->foreign('CC_Id')->references('CC_Id')->on('comp_categories')->onDelete('cascade');
            $table->foreign('SocId')->references('SocId')->on('society_master')->onDelete('cascade');
            $table->foreign('U_Id')->references('U_Id')->on('users_master')->onDelete('cascade');

            $table->index(['CC_Id', 'SocId', 'U_Id']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('complaint_books');
    }
}
