<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNoticeGallaryTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('notice_gallary', function (Blueprint $table) {
            $table->bigIncrements('Ntg_Id');
            $table->unsignedBigInteger('Ntc_Id');
            $table->json('Image'); // Store images as JSON array
            $table->dateTime('Img_Date');
            $table->string('Img_Status', 1);
            $table->timestamps();

            // Foreign Key Constraints
            $table->foreign('Ntc_Id')->references('Ntc_Id')->on('notice_board')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('notice_gallary');
    }
}
