<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNoticeActionLogTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('notice_action_log', function (Blueprint $table) {
            $table->bigIncrements('NA_Sr');
            $table->unsignedBigInteger('Ntc_Id'); // Foreign key to notice table
            $table->unsignedBigInteger('U_Id');   // Foreign key to users table
            $table->unsignedBigInteger('NA_Id'); // Foreign key to NoticeAction table
            $table->timestamps();

            // Foreign Key Constraints
            $table->foreign('Ntc_Id')->references('Ntc_Id')->on('notice_board')->onDelete('cascade');
            $table->foreign('U_Id')->references('U_Id')->on('users_master')->onDelete('cascade');
            $table->foreign('NA_Id')->references('NA_Id')->on('notice_action')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('notice_action_log');
    }
}
