<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNoticeBoardTable extends Migration
{
    public function up()
    {
        Schema::create('notice_board', function (Blueprint $table) {
            $table->bigIncrements('Ntc_Id');
            $table->unsignedBigInteger('Nc_Id');
            $table->string('Title', 250);
            $table->string('Description', 500);
            $table->unsignedBigInteger('SocId');
            $table->string('Severity', 1)->nullable();
            $table->string('Status', 1);
            $table->dateTime('STDate');
            $table->dateTime('EdDate')->nullable();
            $table->unsignedBigInteger('Added_by')->nullable();
            $table->string('Notice_type', 1)->default('N');
            $table->string('Press_by', 1)->nullable();
            $table->timestamps();

            $table->foreign('Nc_Id')->references('Nc_Id')->on('notice_category')->onDelete('cascade');
            $table->foreign('SocId')->references('SocId')->on('society_master')->onDelete('restrict');
            $table->foreign('Added_by')->references('U_Id')->on('users_master')->onDelete('cascade');

            $table->index(['Nc_Id', 'SocId', 'Added_by']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('notice_board');
    }
}
